﻿//////////////////////////////////////////////
// DdsHeader.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkImages
#include "../Enums/DdsHeaderFlag.h"
#include "../Enums/DdsSurfaceComplexity.h"
#include "../Enums/DdsSurfaceDetail.h"

#include "DdsPixelFormat.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkImages::dds
{
	class DdsHeader final
	{
		public :

			// Functions
			// Encode
			void encodeInData (nkMemory::BufferView<unsigned char> data) const ;
			// Decode
			void decodeFromData (nkMemory::BufferView<unsigned char> data) ;

		public :

			// Attributes
			unsigned int _size = 124 ;
			DDS_HEADER_FLAG _flags = DDS_HEADER_FLAG::DDS_HEADER_FLAG_UNKNOWN ;
			unsigned int _height = 0 ;
			unsigned int _width = 0 ;
			unsigned int _rowOrCompressedByteSize = 0 ;
			unsigned int _depth = 0 ;
			unsigned int _mipCount = 0 ;
			
			unsigned int _reservedDdsSurfaceDesc2 [11] ;

			DdsPixelFormat _pixelFormat ;

			DDS_SURFACE_COMPLEXITY _caps1 = DDS_SURFACE_COMPLEXITY::DDS_SURFACE_COMPLEXITY_UNKNOWN ;
			DDS_SURFACE_DETAIL _caps2 = DDS_SURFACE_DETAIL::DDS_SURFACE_DETAIL_UNKNOWN ;

			unsigned int _caps3 = 0 ;
			unsigned int _caps4 = 0 ;
			unsigned int _reserved = 0 ;
	} ;
}